/**
 * \file: mspin_connection_adapter.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin ConnectionAdapter
 *
 * \component: MSPIN
 *
 * \author: Torsten Plate ICT-ADITG/SW2 tplate@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TPlate Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CONNECTION_ADAPTER_H_
#define MSPIN_CONNECTION_ADAPTER_H_

#include "mspin_typedef.h"

#ifdef PROJECTBUILD_NISSAN_LCN2
#include <adit_typedef.h>
#else
#include <adit-system/adit_typedef.h>
#endif

#include <stdlib.h>

mspin_connectionHandle_t* mspin_conn_createHandle(void);

void mspin_conn_releaseHandle(mspin_connectionHandle_t **ppConnectionHandle);

void mspin_conn_enableAOAPPerfomanceMeasurement(void);

mspin_connectionHandle_t* mspin_conn_connectAOAP(mspin_context_t* pContext,
        U32 vendorId, U32 productId, const char* serial, bool* pAudioSupport);

void mspin_conn_disconnectAoap(mspin_context_t* pContext);

mspin_connectionHandle_t* mspin_conn_connectiAP2(mspin_context_t* pContext,
        U32 vendorId, U32 productId, const char* serial,
        const char *pWriteDevice, const char *pReadDevice, bool hostMode);

void mspin_conn_disconnectiAP2(void);

size_t mspin_conn_receive(void* context, UInt8* buffer, size_t bufferSize, void* pMspinContext);

void* mspin_conn_send(void* context, UInt8* buffer, size_t bufferSize, void* pMspinContext);

MSPIN_ERROR mspin_conn_init(void);

MSPIN_ERROR mspin_conn_startUDPListener(S32 port, MSPIN_UDPMessageReceived mesgReceivedCB, void *pUDPListenerContext);

MSPIN_ERROR mspin_conn_stopUDPListener(void);

MSPIN_ERROR mspin_conn_connectTCPServer(mspin_context_t* pContext, const U8* hostname, unsigned int port);

MSPIN_ERROR mspin_conn_disconnectTCPServer(mspin_context_t* pContext);

MSPIN_ERROR mspin_conn_startTCPListener(S32 port, MSPIN_OnAcceptIncomingConnection acceptCB,
        MSPIN_OnConnectionClosed closedCB, void* callbackContext);

MSPIN_ERROR mspin_conn_stopTCPListener(void);

MSPIN_ERROR mspin_conn_startTLSListener(S32 port, MSPIN_TLS_CONFIGURATION_t* pTLSConfig,
        MSPIN_OnAcceptIncomingConnection acceptCB, MSPIN_OnConnectionClosed closedCB, void* callbackContext);

MSPIN_ERROR mspin_conn_stopTLSListener(void);

MSPIN_ERROR mspin_conn_closeTCPConnection(S32 connectionID);

MSPIN_ERROR mspin_conn_getMACAddress(S32 connectionID, U8* macAddress);

MSPIN_ERROR mspin_conn_startUDPBroadcasting(S32 udpPort, const U8* interface,
        MSPIN_UDP_MESSAGE_PARAMETER_t messageParameters, U32 timeout,
        MSPIN_OnUDPBroadcastEnd onUDPBroadcastEnd, void* onUDPBroadcastEndContext);

MSPIN_ERROR mspin_conn_stopUDPBroadcasting(void);

MSPIN_ERROR mspin_conn_startUDPUnicasting(S32 udpPort, const U8* interface,
        const U8* destIPAddr, MSPIN_UDP_MESSAGE_PARAMETER_t messageParameters,
        U32 timeout, MSPIN_OnUDPBroadcastEnd onUDPBroadcastEnd,
        void* onUDPBroadcastEndContext);

MSPIN_ERROR mspin_conn_stopUDPUnicasting(void);

MSPIN_ERROR mspin_conn_connectTCPClient(mspin_context_t* pContext, S32 connectionID);

MSPIN_ERROR mspin_conn_disconnectTCPClient(mspin_context_t* pContext);

MSPIN_ERROR mspin_conn_connectTLSClient(mspin_context_t* pContext, S32 connectionID);

MSPIN_ERROR mspin_conn_disconnectTLSClient(mspin_context_t* pContext);

void mspin_conn_incrementCommCount(mspin_context_t* pContext);

void mspin_conn_decrementCommCount(mspin_context_t* pContext);

S32 mspin_conn_getCommCount(mspin_context_t* pContext);

#endif /* MSPIN_CONNECTION_ADAPTER_H_ */
